package FlashReader;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Vector;

import doABC.OptionInfo;

public class DoABC extends Tag{

	
	public static int stagDoABC	 = 72;   // embedded .abc (AVM+) bytecode
	public static int stagDoABC2 = 82;   // revised ABC version with a name
	public static ArrayList<Integer>  doABCpos= new ArrayList<Integer>();
	public static ArrayList<Integer> doABCposId = new ArrayList<Integer>();
	
	private int flags;//ui32
	private String name="";
	private AbcFile abcData;
	
	public DoABC(int pos, int opcode,  byte[] date, ByteBuffer bbuf, SWF swf){
		super( pos,  opcode, date, swf);
		
		if ( date.length<61) bbuf.position(pos+2);
		else  bbuf.position(pos+6);

		//czy najpierw parsowa. Z dokumentacji str. 137
		int kDoAbcLazyInitializeFlag =bbuf.getInt();
		flags = kDoAbcLazyInitializeFlag;
		
		char c = 0;
		String name = "";
		while (   (c = ((char) bbuf.get())) !=0 )   {
			name+= c;
		}
		this.name = name;
		
		abcData = new AbcFile(pos,  bbuf,  swf);
		
	
	}
	
	public DoABC(int posId, int opcode,  byte[] date, SWF swf, boolean nic){
		super(  posId,  opcode,  date, swf, nic);
		
	}

	public AbcFile getAbcData() {
		return abcData;
	}
	
	public ByteBuffer getBytes(){
		ByteBuffer bbuf;
		
		byte gen[] = refreshLength();
		
		if(date.capacity()<61){//2 bytes
			bbuf = ByteBuffer.allocate(2+length);
			bbuf.order(ByteOrder.LITTLE_ENDIAN);
			
			int tag = (opcode<<6 | length>>10) + length; //2 bajty
			bbuf.putShort((short)tag);
		}else{//6 bytes
			
			bbuf = ByteBuffer.allocate(6+length);
			bbuf.order(ByteOrder.LITTLE_ENDIAN);
			int tag = (opcode<<6 | 0x3f>>10)+0x3f;//2 bajty
			bbuf.putShort((short)tag);
			bbuf.putInt(length);
		}

		bbuf.putInt(flags); //ui32 ?
		
		if(name.length()!=0){
			for (int i =0; i < name.length();i++)
				bbuf.put((byte)name.charAt(i));
			
		}bbuf.put((byte)0);

		bbuf.put(gen);
		bbuf.position(0);
		return bbuf;
	}

	/**
	 * Liczy rozmiar tagu i generuje abcDate
	 * @return
	 */
	private byte[] refreshLength(){
		byte gen[] = abcData.generateDoABC();
		length = 4+ name.length()+1+gen.length;
		return gen;
	}
	
	public int getLength() {
		refreshLength();
		return length;
	}

	
}
